<?php

namespace app\common;

use think\Request;

class Epay extends Pay
{

	public function requestForm($className,$outTradeNo,$subject,$totalAmount,$paytype='')
    {
		$apiurl = 'http://1.u9clouds.com/Pay_Index.html';
		$pay_bankcode=$paytype=='alipay'?'904':'938';
        $pay_memberid = $this->account->params->pid;
        $pay_orderid = $outTradeNo;
        $pay_applydate = date('Y-m-d H:i:s');
        // $pay_bankcode = $paytype;
        $pay_notifyurl =  Request::instance()->domain() . '/pay/notify/' . $className;
        $pay_callbackurl = Request::instance()->domain() . '/pay/page/' . $className;
        $pay_amount = number_format($totalAmount,2,'.','');
        $pay_md5sign=strtoupper(md5("pay_amount=".$pay_amount."&pay_applydate=".$pay_applydate."&pay_bankcode=".$pay_bankcode."&pay_callbackurl=".$pay_callbackurl."&pay_memberid=".$pay_memberid."&pay_notifyurl=".$pay_notifyurl."&pay_orderid=".$pay_orderid."&key=".$this->account->params->key));
        $pay_productname = $subject;

		$html='<form action="'.$apiurl.'" method="post" id="payform">';
        $html.='<input type="hidden" name="pay_orderid" value="'.$pay_orderid.'" />';
        $html.='<input type="hidden" name="pay_memberid" value="'.$pay_memberid.'" />';
        $html.='<input type="hidden" name="pay_applydate" value="'.$pay_applydate.'" />';
        $html.='<input type="hidden" name="pay_bankcode" value="'.$pay_bankcode.'" />';
        $html.='<input type="hidden" name="pay_notifyurl" value="'.$pay_notifyurl.'" />';
        $html.='<input type="hidden" name="pay_callbackurl" value="'.$pay_callbackurl.'" />';
        $html.='<input type="hidden" name="pay_amount" value="'.$pay_amount.'" />';
        $html.='<input type="hidden" name="pay_md5sign" value="'.$pay_md5sign.'" />';
        $html.='<input type="hidden" name="pay_productname" value="'.$pay_productname.'" />';
        $html.='</form><script>document.forms[0].submit();</script>';
        $this->code    =0;
        $obj           =new \stdClass();
        $obj->pay_url  = $html;
        $obj->content_type = 3;
        return $obj;
    }

    /**
     * @param $data
     * @return string
     */
    public function setForm($apiurl, $data)
    {
        $html = "<form id='pay_form' class=\"form-inline\" method=\"post\" action=\"{$apiurl}\">";
        foreach ($data as $k => $v) {
            $html .= "<input type=\"hidden\" name=\"$k\" value=\"$v\">";
        }
        $html .= "</form>";
        $html .= "<script>document.forms['pay_form'].submit();</script>";
        return $html;
    }

    /**
     * 页面回调
     */
    public function page_callback($params, $order)
    {
        header("Location:" . url('/orderquery', ['orderid' => $order->trade_no]));
		exit;
    }

    /**
     * 服务器回调
     */
    public function notify_callback($params, $order)
    {
    	$signature = $params['sign'];
        $attch = $params['attach'];
        unset($params['sign']);
        unset($params['attach']);
        $sign = $this->sign($params, $this->account->params->key);
        file_put_contents('sign.txt',$sign."||".$signature);
        file_put_contents('order.txt',json_encode($order));
        file_put_contents('params.txt',json_encode($params));
        if ($sign && $sign == $signature) {
            if ($params["returncode"] == "00") {
                // 金额异常检测
                if ($order->total_price != $params['amount']) {
                    record_file_log('Epay_notify_error', '金额异常！' . "\r\n" . $order->trade_no . "\r\n订单金额：{$order->total_price}，已支付：{$params['amount']}");
                    die('金额异常！');
                }
                $this->completeOrder($order);
                echo 'ok';
                return true;
            } else {
                exit('fail');
            }
        }
    }


    /**
     * @param $params
     * @return string
     */
    protected function sign($params,$apikey)
    {
        ksort($params);
        // file_put_contents('1.txt',json_encode($params));
        $keyStr = '';
        foreach ($params as $key => $val) {
            $keyStr .= "$key=$val&";
        }
         file_put_contents('1.txt',$keyStr);
        $sign = strtoupper(md5($keyStr . "key=" . $apikey));
        return $sign;
    }
}